// This file was generated Sat Mar 18 20:58:10 2017


// Declaration of all drivers
#define DRV extern struct BurnDriver
DRV BurnDrvAblast;
DRV	BurnDrvArbalest;
DRV	BurnDrvAtehate;
DRV	BurnDrvBlandia;
DRV	BurnDrvBlandiap;
DRV	BurnDrvBlockcar;
DRV	BurnDrvCalibr50;
DRV	BurnDrvCrazyfgt;
DRV	BurnDrvDaioh;
DRV	BurnDrvDaiohc;
DRV	BurnDrvDaioha;
DRV	BurnDrvDaiohp;
DRV	BurnDrvDeerhunc;
DRV	BurnDrvDeerhunb;
DRV	BurnDrvDeerhuna;
DRV	BurnDrvDeerhunt;
DRV	BurnDrvDowntownj;
DRV	BurnDrvDowntown;
DRV	BurnDrvDowntown2;
DRV	BurnDrvDowntownp;
DRV	BurnDrvDrgnmst;
DRV	BurnDrvDrgnunit;
DRV	BurnDrvEightfrc;
DRV	BurnDrvExtdwnhl;
DRV	BurnDrvF1gp;
#if defined FBA_DEBUG
DRV	BurnDrvF1gpb;
#endif
DRV	BurnDrvF1gp2;
#if defined FBA_DEBUG
DRV	BurnDrvFuncube2;   		// Unemulated Sub CPU
DRV	BurnDrvFuncube4;   		// Unemulated Sub CPU
#endif
DRV	BurnDrvPowerinj;
DRV	BurnDrvGrdians;
DRV	BurnDrvGundhara;
DRV	BurnDrvGundharac;
#if defined FBA_DEBUG
DRV	BurnDrvInttoote;
DRV	BurnDrvInttootea;
#endif
DRV	BurnDrvJjsquawk;
DRV	BurnDrvJjsquawkb;
DRV	BurnDrvJjsquawkb2;
DRV	BurnDrvJjsquawko;
DRV	BurnDrvJchan;
DRV	BurnDrvJchan2;
#if defined FBA_DEBUG
DRV	BurnDrvJockeyc;
#endif
DRV	BurnDrvKeroppij;
DRV	BurnDrvKeroppi;
DRV	BurnDrvMyangel;
DRV	BurnDrvMyangel2;
DRV	BurnDrvKrzybowl;
DRV	BurnDrvSilkroad;
DRV	BurnDrvMadshark;
DRV	BurnDrvKamenrid;
DRV	BurnDrvMetafox;
DRV	BurnDrvMsgundam;
DRV	BurnDrvMsgundam1;
DRV	BurnDrvGundamex;
DRV	BurnDrvOisipuzl;
DRV	BurnDrvOrbs;
DRV	BurnDrvPairlove;
DRV	BurnDrvPenbros;
DRV	BurnDrvPowerins;
DRV	BurnDrvPowerina;
DRV	BurnDrvPowerinb;
#if defined FBA_DEBUG
DRV	BurnDrvKiwame;
#endif
DRV	BurnDrvPzlbowl;
DRV	BurnDrvQzkklogy;
DRV	BurnDrvQzkklgy2;
DRV	BurnDrvRezon;
DRV	BurnDrvRezont;
DRV	BurnDrvNeobattl;
DRV	BurnDrvSandscrp;
DRV	BurnDrvSandscrpb;
DRV	BurnDrvSandscrpa;
DRV	BurnDrvSokonuke;
DRV	BurnDrvStg;
DRV	BurnDrvSuperbar;
DRV	BurnDrvThunderl;
DRV	BurnDrvTndrcade;
DRV	BurnDrvTndrcadej;
DRV	BurnDrvTriplfun;
DRV	BurnDrvTrophyh;
DRV	BurnDrvTurkhunt;
DRV	BurnDrvTwineagl;
DRV	BurnDrvUsclssic;
DRV	BurnDrvUtoukond;
DRV	BurnDrvUmanclub;
#if defined FBA_DEBUG
DRV	BurnDrvSetaroul;
#endif
DRV	BurnDrvMj4simai;
DRV	BurnDrvWrofaero;
DRV	BurnDrvWiggie;
DRV	BurnDrvWschampa;
DRV	BurnDrvWschamp;
DRV	BurnDrvWits;
DRV	BurnDrvZingzip;
DRV	BurnDrvZombraidpj;
DRV	BurnDrvZombraid;
DRV	BurnDrvZombraidp;
#undef DRV

// Structure containing addresses of all drivers
// Needs to be kept sorted (using the full game name as the key) to prevent problems with the gamelist in Kaillera
static struct BurnDriver* pDriver[] = {
	&BurnDrvAblast,			// A-Blast (Japan)
	&BurnDrvArbalest,		// Arbalester
	&BurnDrvAtehate,		// Athena no Hatena ?
	&BurnDrvBlandia,		// Blandia
	&BurnDrvBlandiap,		// Blandia (prototype)
	&BurnDrvBlockcar,		// Block Carnival / Thunder & Lightning 2
	&BurnDrvCalibr50,		// Caliber 50
	&BurnDrvCrazyfgt,		// Crazy Fight
	&BurnDrvDaioh,			// Daioh
	&BurnDrvDaiohc,			// Daioh (93111A PCB conversion)
	&BurnDrvDaioha,			// Daioh (earlier)
	&BurnDrvDaiohp,			// Daioh (prototype)
	&BurnDrvDeerhunc,		// Deer Hunting USA V2
	&BurnDrvDeerhunb,		// Deer Hunting USA V4.0
	&BurnDrvDeerhuna,		// Deer Hunting USA V4.2
	&BurnDrvDeerhunt,		// Deer Hunting USA V4.3
	&BurnDrvDowntownj,		// DownTown / Mokugeki (Joystick Hack)
	&BurnDrvDowntown,		// DownTown / Mokugeki (Set 1)
	&BurnDrvDowntown2,		// DownTown / Mokugeki (Set 2)
	&BurnDrvDowntownp,		// DownTown / Mokugeki (prototype)
	&BurnDrvDrgnmst,		// Dragon Master
	&BurnDrvDrgnunit,		// Dragon Unit / Castle of Dragon
	&BurnDrvEightfrc,		// Eight Forces
	&BurnDrvExtdwnhl,		// Extreme Downhill (v1.5)
	&BurnDrvF1gp,			// F-1 Grand Prix
#if defined FBA_DEBUG
	&BurnDrvF1gpb,			// F-1 Grand Prix (Playmark bootleg)
#endif
	&BurnDrvF1gp2,			// F-1 Grand Prix Part II
#if defined FBA_DEBUG
	&BurnDrvFuncube2,		// Funcube 2 (v1.1)
	&BurnDrvFuncube4,		// Funcube 4 (v1.0)
#endif
	&BurnDrvPowerinj,		// Gouketsuji Ichizoku (Japan)
	&BurnDrvGrdians,		// Guardians
	&BurnDrvGundhara,		// Gundhara
	&BurnDrvGundharac,		// Gundhara (Chinese, bootleg?)
#if defined FBA_DEBUG
	&BurnDrvInttoote,		// International Toote (Germany)
	&BurnDrvInttootea,		// International Toote II (World?)
#endif
	&BurnDrvJjsquawk,		// J. J. Squawkers
	&BurnDrvJjsquawkb,		// J. J. Squawkers (bootleg)
	&BurnDrvJjsquawkb2,		// J. J. Squawkers (bootleg, Blandia conversion)
	&BurnDrvJjsquawko,		// J. J. Squawkers (older)
	&BurnDrvJchan,			// Jackie Chan - The Kung-Fu Master
	&BurnDrvJchan2,			// Jackie Chan in Fists of Fire
#if defined FBA_DEBUG
	&BurnDrvJockeyc,		// Jockey Club
#endif
	&BurnDrvKeroppij,		// Kero Kero Keroppi no Issyoni Asobou (Japan)
	&BurnDrvKeroppi,		// Kero Kero Keroppi's Let's Play Together (USA, Version 2.0)
	&BurnDrvMyangel,		// Kosodate Quiz My Angel (Japan)
	&BurnDrvMyangel2,		// Kosodate Quiz My Angel 2 (Japan)
    &BurnDrvKrzybowl,		// Krazy Bowl
	&BurnDrvSilkroad,		// Legend of Silkroad, The
	&BurnDrvMadshark,		// Mad Shark
	&BurnDrvKamenrid,		// Masked Riders Club Battle Race
	&BurnDrvMetafox,		// Meta Fox
	&BurnDrvMsgundam,		// Mobile Suit Gundam
	&BurnDrvMsgundam1,		// Mobile Suit Gundam (Japan)
	&BurnDrvGundamex,		// Mobile Suit Gundam EX Revue
	&BurnDrvOisipuzl,		// Oishii Puzzle Ha Irimasenka
	&BurnDrvOrbs,			// Orbs (10/7/94 prototype?)
	&BurnDrvPairlove,		// Pairs Love
	&BurnDrvPenbros,		// Penguin Brothers (Japan)
	&BurnDrvPowerins,		// Power Instinct (USA)
	&BurnDrvPowerina,		// Power Instinct (USA, bootleg set 1)
	&BurnDrvPowerinb,		// Power Instinct (USA, bootleg set 2)
#if defined FBA_DEBUG
	&BurnDrvKiwame,			// Pro Mahjong Kiwame
#endif
	&BurnDrvPzlbowl,		// Puzzle De Bowling (Japan)
	&BurnDrvQzkklogy,		// Quiz Kokology
	&BurnDrvQzkklgy2,		// Quiz Kokology 2
	&BurnDrvRezon,			// Rezon
	&BurnDrvRezont,			// Rezon (Taito)
	&BurnDrvNeobattl,		// SD Gundam Neo Battling (Japan)
	&BurnDrvSandscrp,		// Sand Scorpion
	&BurnDrvSandscrpb,		// Sand Scorpion (Chinese Title Screen, Revised Hardware)
	&BurnDrvSandscrpa,		// Sand Scorpion (Earlier)
	&BurnDrvSokonuke,		// Sokonuke Taisen Game (Japan)
	&BurnDrvStg,			// Strike Gunner S.T.G
	&BurnDrvSuperbar,		// Super Bar
	&BurnDrvThunderl,		// Thunder & Lightning
	&BurnDrvTndrcade,		// Thundercade / Twin Formation
	&BurnDrvTndrcadej,		// Tokusyu Butai U.A.G. (Japan)
	&BurnDrvTriplfun,		// Triple Fun
	&BurnDrvTrophyh,		// Trophy Hunting - Bear & Moose V1.0
	&BurnDrvTurkhunt,		// Turkey Hunting USA V1.0
	&BurnDrvTwineagl,		// Twin Eagle - Revenge Joe's Brother
    &BurnDrvUsclssic,		// U.S. Classic
	&BurnDrvUtoukond,		// Ultra Toukon Densetsu (Japan)
	&BurnDrvUmanclub,		// Ultraman Club - Tatakae! Ultraman Kyoudai!!
#if defined FBA_DEBUG
	&BurnDrvSetaroul,		// Visco Roulette
#endif
	&BurnDrvMj4simai,		// Wakakusamonogatari Mahjong Yonshimai (Japan)
	&BurnDrvWrofaero,		// War of Aero - Project MEIOU
	&BurnDrvWiggie,			// Wiggie Waggie
	&BurnDrvWschampa,		// Wing Shooting Championship V1.01
	&BurnDrvWschamp,		// Wing Shooting Championship V2.00
	&BurnDrvWits,			// Wit's (Japan)
	&BurnDrvZingzip,		// Zing Zing Zip
	&BurnDrvZombraidpj,		// Zombie Raid (9/28/95, Japan, prototype PCB)
	&BurnDrvZombraid,		// Zombie Raid (9/28/95, US)
	&BurnDrvZombraidp,		// Zombie Raid (9/28/95, US, prototype PCB)
};

static struct BurnDriver* pAllDrivers[] = {
	&BurnDrvAblast,			// A-Blast (Japan)
	&BurnDrvArbalest,		// Arbalester
	&BurnDrvAtehate,		// Athena no Hatena ?
	&BurnDrvBlandia,		// Blandia
	&BurnDrvBlandiap,		// Blandia (prototype)
	&BurnDrvBlockcar,		// Block Carnival / Thunder & Lightning 2
	&BurnDrvCalibr50,		// Caliber 50
	&BurnDrvCrazyfgt,		// Crazy Fight
	&BurnDrvDaioh,			// Daioh
	&BurnDrvDaiohc,			// Daioh (93111A PCB conversion)
	&BurnDrvDaioha,			// Daioh (earlier)
	&BurnDrvDaiohp,			// Daioh (prototype)
	&BurnDrvDeerhunc,		// Deer Hunting USA V2
	&BurnDrvDeerhunb,		// Deer Hunting USA V4.0
	&BurnDrvDeerhuna,		// Deer Hunting USA V4.2
	&BurnDrvDeerhunt,		// Deer Hunting USA V4.3
	&BurnDrvDowntownj,		// DownTown / Mokugeki (Joystick Hack)
	&BurnDrvDowntown,		// DownTown / Mokugeki (Set 1)
	&BurnDrvDowntown2,		// DownTown / Mokugeki (Set 2)
	&BurnDrvDowntownp,		// DownTown / Mokugeki (prototype)
	&BurnDrvDrgnmst,		// Dragon Master
	&BurnDrvDrgnunit,		// Dragon Unit / Castle of Dragon
	&BurnDrvEightfrc,		// Eight Forces
	&BurnDrvExtdwnhl,		// Extreme Downhill (v1.5)
	&BurnDrvF1gp,			// F-1 Grand Prix
#if defined FBA_DEBUG
	&BurnDrvF1gpb,			// F-1 Grand Prix (Playmark bootleg)
#endif
	&BurnDrvF1gp2,			// F-1 Grand Prix Part II
#if defined FBA_DEBUG
	&BurnDrvFuncube2,		// Funcube 2 (v1.1)
	&BurnDrvFuncube4,		// Funcube 4 (v1.0)
#endif
	&BurnDrvPowerinj,		// Gouketsuji Ichizoku (Japan)
	&BurnDrvGrdians,		// Guardians
	&BurnDrvGundhara,		// Gundhara
	&BurnDrvGundharac,		// Gundhara (Chinese, bootleg?)
#if defined FBA_DEBUG
	&BurnDrvInttoote,		// International Toote (Germany)
	&BurnDrvInttootea,		// International Toote II (World?)
#endif
	&BurnDrvJjsquawk,		// J. J. Squawkers
	&BurnDrvJjsquawkb,		// J. J. Squawkers (bootleg)
	&BurnDrvJjsquawkb2,		// J. J. Squawkers (bootleg, Blandia conversion)
	&BurnDrvJjsquawko,		// J. J. Squawkers (older)
	&BurnDrvJchan,			// Jackie Chan - The Kung-Fu Master
	&BurnDrvJchan2,			// Jackie Chan in Fists of Fire
#if defined FBA_DEBUG
	&BurnDrvJockeyc,		// Jockey Club
#endif
	&BurnDrvKeroppij,		// Kero Kero Keroppi no Issyoni Asobou (Japan)
	&BurnDrvKeroppi,		// Kero Kero Keroppi's Let's Play Together (USA, Version 2.0)
	&BurnDrvMyangel,		// Kosodate Quiz My Angel (Japan)
	&BurnDrvMyangel2,		// Kosodate Quiz My Angel 2 (Japan)
    &BurnDrvKrzybowl,		// Krazy Bowl
	&BurnDrvSilkroad,		// Legend of Silkroad, The
	&BurnDrvMadshark,		// Mad Shark
	&BurnDrvKamenrid,		// Masked Riders Club Battle Race
	&BurnDrvMetafox,		// Meta Fox
	&BurnDrvMsgundam,		// Mobile Suit Gundam
	&BurnDrvMsgundam1,		// Mobile Suit Gundam (Japan)
	&BurnDrvGundamex,		// Mobile Suit Gundam EX Revue
	&BurnDrvOisipuzl,		// Oishii Puzzle Ha Irimasenka
	&BurnDrvOrbs,			// Orbs (10/7/94 prototype?)
	&BurnDrvPairlove,		// Pairs Love
	&BurnDrvPenbros,		// Penguin Brothers (Japan)
	&BurnDrvPowerins,		// Power Instinct (USA)
	&BurnDrvPowerina,		// Power Instinct (USA, bootleg set 1)
	&BurnDrvPowerinb,		// Power Instinct (USA, bootleg set 2)
#if defined FBA_DEBUG
	&BurnDrvKiwame,			// Pro Mahjong Kiwame
#endif
	&BurnDrvPzlbowl,		// Puzzle De Bowling (Japan)
	&BurnDrvQzkklogy,		// Quiz Kokology
	&BurnDrvQzkklgy2,		// Quiz Kokology 2
	&BurnDrvRezon,			// Rezon
	&BurnDrvRezont,			// Rezon (Taito)
	&BurnDrvNeobattl,		// SD Gundam Neo Battling (Japan)
	&BurnDrvSandscrp,		// Sand Scorpion
	&BurnDrvSandscrpb,		// Sand Scorpion (Chinese Title Screen, Revised Hardware)
	&BurnDrvSandscrpa,		// Sand Scorpion (Earlier)
	&BurnDrvSokonuke,		// Sokonuke Taisen Game (Japan)
	&BurnDrvStg,			// Strike Gunner S.T.G
	&BurnDrvSuperbar,		// Super Bar
	&BurnDrvThunderl,		// Thunder & Lightning
	&BurnDrvTndrcade,		// Thundercade / Twin Formation
	&BurnDrvTndrcadej,		// Tokusyu Butai U.A.G. (Japan)
	&BurnDrvTriplfun,		// Triple Fun
	&BurnDrvTrophyh,		// Trophy Hunting - Bear & Moose V1.0
	&BurnDrvTurkhunt,		// Turkey Hunting USA V1.0
	&BurnDrvTwineagl,		// Twin Eagle - Revenge Joe's Brother
    &BurnDrvUsclssic,		// U.S. Classic
	&BurnDrvUtoukond,		// Ultra Toukon Densetsu (Japan)
	&BurnDrvUmanclub,		// Ultraman Club - Tatakae! Ultraman Kyoudai!!
#if defined FBA_DEBUG
	&BurnDrvSetaroul,		// Visco Roulette
#endif
	&BurnDrvMj4simai,		// Wakakusamonogatari Mahjong Yonshimai (Japan)
	&BurnDrvWrofaero,		// War of Aero - Project MEIOU
	&BurnDrvWiggie,			// Wiggie Waggie
	&BurnDrvWschampa,		// Wing Shooting Championship V1.01
	&BurnDrvWschamp,		// Wing Shooting Championship V2.00
	&BurnDrvWits,			// Wit's (Japan)
	&BurnDrvZingzip,		// Zing Zing Zip
	&BurnDrvZombraidpj,		// Zombie Raid (9/28/95, Japan, prototype PCB)
	&BurnDrvZombraid,		// Zombie Raid (9/28/95, US)
	&BurnDrvZombraidp,		// Zombie Raid (9/28/95, US, prototype PCB)
};

